/*
 * Decompiled with CFR 0.152.
 */
package gloridifice.watersource.common.network;

import gloridifice.watersource.common.network.INormalMessage;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.items.CapabilityItemHandler;

public class WaterFilterMessage
implements INormalMessage {
    int x;
    int y;
    int z;
    FluidStack fluid;
    ItemStack strainer;

    public WaterFilterMessage(FluidStack stack, int x, int y, int z, ItemStack strainer) {
        this.fluid = stack;
        this.strainer = strainer;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public WaterFilterMessage(PacketBuffer buf) {
        this.fluid = buf.readFluidStack();
        this.strainer = buf.func_150791_c();
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        buf.writeFluidStack(this.fluid);
        buf.func_150788_a(this.strainer);
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
    }

    @Override
    public void process(Supplier<NetworkEvent.Context> context) {
        if (context.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            context.get().enqueueWork(() -> {
                TileEntity tileEntity = Minecraft.func_71410_x().field_71439_g.func_130014_f_().func_175625_s(new BlockPos(this.x, this.y, this.z));
                tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).ifPresent(data -> {
                    data.drain(data.getTankCapacity(0), IFluidHandler.FluidAction.EXECUTE);
                    data.fill(this.fluid, IFluidHandler.FluidAction.EXECUTE);
                });
                if (!this.strainer.func_190926_b()) {
                    tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(data -> {
                        data.extractItem(0, 64, false);
                        data.insertItem(0, this.strainer, false);
                    });
                }
            });
        }
    }
}

